#include <windows>
#include <setupapi>
#include <assert>
#include <iostream>
#include <sysutils.hpp>

#define searchMaxDevices 10 //maksymalna liczba interfejsw urzdzen

using namespace std;
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
//--------------------------------------------------------
typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef struct _DEVICE_DATA {
  TCHAR   *HardwareId;
  TCHAR   *Path;
  DWORD   DeviceInstance;
  HANDLE  hidDeviceObject;
  BYTE    *inputReportBuffer;
  USHORT  inputReportByteLength;
  /*...*/
  USHORT  outputReportByteLength;
  USHORT  featureReportByteLength;
  /*...*/
  PHIDP_PREPARSED_DATA preparsedData;
  HIDP_CAPS capabilities;
} DEVICE_DATA, *PDEVICE_DATA;
//---------------------------------------------------------
class TUSBDevice {
   private:
      UINT fMemberIndex;
      void displayError(const char* msg);
   public:
      PDEVICE_DATA deviceList;
      BOOL getHidDeviceCapabilities(UINT memberIndex);
      UINT setGetHidDeviceData();
      HANDLE openHidUSBDevice(UINT memberIndex);
      BOOL readUSBReport(UINT memberIndex);
      BOOL closeHidUSBDevice(HANDLE devHandle);
      TUSBDevice(UINT memberIndex);
      ~TUSBDevice();
};
//---------------------------------------------------------
TUSBDevice::TUSBDevice(UINT memberIndex)
{
   fMemberIndex = memberIndex;
   deviceList = (PDEVICE_DATA)new \
              DEVICE_DATA[((fMemberIndex+1)*sizeof(DEVICE_DATA))];
}
//---------------------------------------------------------
TUSBDevice::~TUSBDevice()
{
   releaseMemory(deviceList);
   system("PAUSE");
}
//---------------------------------------------------------
void TUSBDevice::displayError(const char* msg)
{
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
BOOL TUSBDevice::getHidDeviceCapabilities(UINT memberIndex)
{
   HMODULE hHidLib;
   bool status;

   long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);
   bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                    OUT PHIDP_PREPARSED_DATA *PreparsedData);

   bool (__stdcall* HidD_FreePreparsedData)
                                    (IN PHIDP_PREPARSED_DATA PreparsedData);

   hHidLib = LoadLibrary("HID.DLL");
   if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
   (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
   (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");

   if (!HidP_GetCaps || !HidD_GetPreparsedData || !HidD_FreePreparsedData){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }
   status=HidD_GetPreparsedData(deviceList[memberIndex].hidDeviceObject,
                                &deviceList->preparsedData);
   if(status){
      HidP_GetCaps(deviceList->preparsedData, &deviceList->capabilities);
      deviceList[memberIndex].inputReportByteLength =
                               deviceList->capabilities.InputReportByteLength;
      deviceList[memberIndex].outputReportByteLength =
                               deviceList->capabilities.OutputReportByteLength;
      deviceList[memberIndex].featureReportByteLength =
                               deviceList->capabilities.FeatureReportByteLength;
      HidD_FreePreparsedData(deviceList->preparsedData);
   }
   FreeLibrary(hHidLib);
   return status;
}
//---------------------------------------------------------
UINT TUSBDevice::setGetHidDeviceData()
{
    DWORD propertyBufferSize = 0;
    char *propertyBuffer = NULL;
    HMODULE hHidLib;
    SP_DEVINFO_DATA deviceInfoData;
    HDEVINFO deviceInfoSet;
    SP_INTERFACE_DEVICE_DATA deviceInterfaceData;
    fMemberIndex = 0;
    GUID classGuid;
    PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
    DWORD requiredSize = 0;
    DWORD deviceInterfaceDetailDataSize = 0;
    DWORD maxDevice = searchMaxDevices;
    bool done = false;

    void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

    hHidLib = LoadLibrary("HID.DLL");
    if (!hHidLib)
      displayError("Bd doczenia biblioteki HID.DLL.");

    (FARPROC&) HidD_GetHidGuid = GetProcAddress(hHidLib,
                                              "HidD_GetHidGuid");
    if (!HidD_GetHidGuid){
       FreeLibrary(hHidLib);
       displayError("Nie znaleziono identyfikatora GIUD.");
    }

    HidD_GetHidGuid (&classGuid);

    deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                                       (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE));

    deviceInterfaceData.cbSize = sizeof(SP_INTERFACE_DEVICE_DATA);

    while(!done) {
       for(; fMemberIndex < maxDevice; fMemberIndex++) {
          if(SetupDiEnumDeviceInterfaces(deviceInfoSet,0,&classGuid,
                                         fMemberIndex,&deviceInterfaceData)) {
            SetupDiGetDeviceInterfaceDetail(deviceInfoSet,&deviceInterfaceData,
                                         NULL,0,&deviceInterfaceDetailDataSize,
                                         NULL);
            requiredSize = deviceInterfaceDetailDataSize;
            deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)\
                                new DWORD[deviceInterfaceDetailDataSize];

               if(deviceInterfaceDetailData) {
                  deviceInterfaceDetailData->cbSize=\
                               sizeof(SP_INTERFACE_DEVICE_DETAIL_DATA);
               }
               else {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
               }
               deviceInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
               if(!SetupDiGetDeviceInterfaceDetail(deviceInfoSet,
                           &deviceInterfaceData, deviceInterfaceDetailData,
                           deviceInterfaceDetailDataSize,
                           &requiredSize, &deviceInfoData)) {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
               }

            size_t nLen = strlen(deviceInterfaceDetailData->DevicePath) + 1;
            deviceList[fMemberIndex].Path = new TCHAR[(nLen*sizeof(TCHAR))];
            StrLCopy(deviceList[fMemberIndex].Path,
                                deviceInterfaceDetailData->DevicePath, nLen);

            deviceList[fMemberIndex].DeviceInstance = deviceInfoData.DevInst;

            SetupDiGetDeviceRegistryProperty(deviceInfoSet, &deviceInfoData,
                                        SPDRP_HARDWAREID, NULL, NULL, 0,
                                        &propertyBufferSize);

            //alokowanie pamieci dla bufora danych
            propertyBuffer = new char[(propertyBufferSize*sizeof(TCHAR))];

            SetupDiGetDeviceRegistryProperty(deviceInfoSet, &deviceInfoData,
                                           SPDRP_HARDWAREID,NULL,
                                           propertyBuffer, propertyBufferSize,
                                           NULL);

            deviceList[fMemberIndex].HardwareId  = propertyBuffer;
            cout <<"\nDeviceList["<<fMemberIndex<<"].HardwareId: \n" <<
                     deviceList[fMemberIndex].HardwareId << endl;

            releaseMemory(deviceInterfaceDetailData);
            releaseMemory(propertyBuffer);
          }
          else {
              if(ERROR_NO_MORE_ITEMS == GetLastError()){
                 done = TRUE;
                 break;
              }
          }
       }
    }
    SetupDiDestroyDeviceInfoList(deviceInfoSet);
    FreeLibrary(hHidLib);
    return fMemberIndex;
}
//---------------------------------------------------------
HANDLE TUSBDevice::openHidUSBDevice(UINT memberIndex)
{
   deviceList[memberIndex].hidDeviceObject == INVALID_HANDLE_VALUE;
   deviceList[memberIndex].hidDeviceObject =
                      CreateFile(deviceList[memberIndex].Path,
                                 GENERIC_READ | GENERIC_WRITE,
                                 FILE_SHARE_READ | FILE_SHARE_WRITE,
                                 NULL,OPEN_EXISTING,FILE_FLAG_OVERLAPPED,NULL);

   if(deviceList[memberIndex].hidDeviceObject != INVALID_HANDLE_VALUE)
     return deviceList[memberIndex].hidDeviceObject;
     else
       return INVALID_HANDLE_VALUE;
}
//---------------------------------------------------------
BOOL TUSBDevice::closeHidUSBDevice(HANDLE devHandle)
{
  if((devHandle == 0) ||
    (devHandle == INVALID_HANDLE_VALUE)){
    return false;
  }
  else
    return Win32Check(CloseHandle(devHandle));
}
//---------------------------------------------------------
BOOL TUSBDevice::readUSBReport(UINT memberIndex)
{
   DWORD result = 0;
   DWORD numberOfBytesRead = 0;
   OVERLAPPED *overlapped = NULL;
   if(overlapped == NULL){
       overlapped = new OVERLAPPED;
       overlapped->hEvent = CreateEvent(NULL, TRUE, TRUE, "");
       overlapped->Offset = 0;
       overlapped->OffsetHigh = 0;
   }
   memset(deviceList[memberIndex].inputReportBuffer, 0x00,
          deviceList[memberIndex].inputReportByteLength);
   if(!ReadFile(deviceList[memberIndex].hidDeviceObject,
                deviceList[memberIndex].inputReportBuffer,
                deviceList[memberIndex].inputReportByteLength,
                &numberOfBytesRead, overlapped)) {
      if(GetLastError() == ERROR_IO_PENDING) {
          result = WaitForSingleObject(overlapped->hEvent, 100);
	        if(result == WAIT_TIMEOUT) {
	            CancelIo(deviceList[memberIndex].hidDeviceObject);
	            return false;
	        }
	        else
                    if(result == WAIT_FAILED){
	              displayError("Bd odczytu danych.");
	              return false;
	            }
	        GetOverlappedResult(deviceList[memberIndex].hidDeviceObject,
                                    overlapped, &numberOfBytesRead, FALSE);
      }
      else
         displayError("Bd odczytu danych.");
   }
   ResetEvent(overlapped->hEvent);
   if(numberOfBytesRead == (UINT)deviceList[memberIndex].inputReportByteLength){
     for(USHORT i=0; i< deviceList[memberIndex].inputReportByteLength; i++)
        printf("%d ", deviceList[memberIndex].inputReportBuffer[i]);
        printf("\n");
   }
   else {
     printf("Bledna liczba bajtow odebranych.\n",numberOfBytesRead);
   }
   releaseMemory(overlapped);
   return true;
}
//---------------------------------------------------------
int main(){
   UINT interfaceIndex = 3;//numer istniejcego
                           //interfejsu urzadzenia HID

   //stworzenie obiektu klasy TUSBDevice
   TUSBDevice *usbDevice = new TUSBDevice(interfaceIndex);

   //enumeracja aktualnie podlaczonych urzadzen klasy HID
   usbDevice->setGetHidDeviceData();

   cout <<"\nDeviceList["<<interfaceIndex<<"].Path: \n" <<
            usbDevice->deviceList[interfaceIndex].Path << endl;

   //otwarcie portu USB
   usbDevice->openHidUSBDevice(interfaceIndex);

   //odczyt wlasciwosci urzdzenia
   if (usbDevice->getHidDeviceCapabilities(interfaceIndex)) {
      usbDevice->deviceList[interfaceIndex].inputReportBuffer = new \
              BYTE[usbDevice->deviceList[interfaceIndex].inputReportByteLength];
      while(true) { //cykliczny odczyt raportu wejsciowego
        usbDevice->readUSBReport(interfaceIndex);
        if(usbDevice->deviceList[interfaceIndex].inputReportBuffer[6]==64)
           break;
      }
      usbDevice->closeHidUSBDevice(usbDevice->deviceList[interfaceIndex].\
                                                         hidDeviceObject);
   }
   releaseMemory(usbDevice->deviceList[interfaceIndex].Path);
   releaseMemory(usbDevice->deviceList[interfaceIndex].inputReportBuffer);
   //wywoanie destruktora klasy TUSBDevice
   releaseMemory(usbDevice);
   return 0;
}
//---------------------------------------------------------

